/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class InventoryMoveTest
extends AbstractTestCase {
    private static final int OAK_PRODUCT_ID = 123;
    private static final int ELM_PRODUCT_ID = 124;
    private static final int HQ_WAREHOUSE_ID = 103;
    private static final int STORE_WAREHOUSE_ID = 104;
    private static final int UOM_SIXPACK_ID = 109;

    @Test
    public void testInventoryMove() {
        BigDecimal qtyOnHandHQ = MStorageOnHand.getQtyOnHandWithASIZero((int)123, (int)103, (String)this.getTrxName());
        BigDecimal qtyOnHandStore = MStorageOnHand.getQtyOnHandWithASIZero((int)123, (int)104, (String)this.getTrxName());
        MMovement mh = new MMovement(Env.getCtx(), 0, this.getTrxName());
        mh.setM_Warehouse_ID(103);
        mh.setM_WarehouseTo_ID(104);
        mh.saveEx();
        MMovementLine ml = new MMovementLine(mh);
        ml.setM_Product_ID(123);
        ml.setM_LocatorTo_ID(MWarehouse.get((int)104).getDefaultLocator().get_ID());
        ml.setM_Locator_ID(MWarehouse.get((int)103).getDefaultLocator().get_ID());
        BigDecimal qtyMove = BigDecimal.ONE;
        ml.setMovementQty(qtyMove);
        ml.saveEx();
        Assertions.assertTrue((ml.getQtyEntered().compareTo(ml.getMovementQty()) == 0 ? 1 : 0) != 0);
        mh.processIt("CO");
        BigDecimal newQtyOnHandHQ = MStorageOnHand.getQtyOnHandWithASIZero((int)123, (int)103, (String)this.getTrxName());
        BigDecimal newQtyOnHandStore = MStorageOnHand.getQtyOnHandWithASIZero((int)123, (int)104, (String)this.getTrxName());
        Assertions.assertTrue((newQtyOnHandHQ.compareTo(qtyOnHandHQ.subtract(qtyMove)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((newQtyOnHandStore.compareTo(qtyOnHandStore.add(qtyMove)) == 0 ? 1 : 0) != 0);
        this.rollback();
        mh = new MMovement(Env.getCtx(), 0, this.getTrxName());
        mh.setM_Warehouse_ID(103);
        mh.setM_WarehouseTo_ID(104);
        mh.saveEx();
        ml = new MMovementLine(mh);
        ml.setM_Product_ID(123);
        ml.setM_LocatorTo_ID(MWarehouse.get((int)104).getDefaultLocator().get_ID());
        ml.setM_Locator_ID(MWarehouse.get((int)103).getDefaultLocator().get_ID());
        qtyMove = BigDecimal.ONE;
        ml.setQtyEntered(qtyMove);
        ml.saveEx();
        Assertions.assertTrue((ml.getQtyEntered().compareTo(ml.getMovementQty()) == 0 ? 1 : 0) != 0);
        mh.processIt("CO");
        newQtyOnHandHQ = MStorageOnHand.getQtyOnHandWithASIZero((int)123, (int)103, (String)this.getTrxName());
        newQtyOnHandStore = MStorageOnHand.getQtyOnHandWithASIZero((int)123, (int)104, (String)this.getTrxName());
        Assertions.assertTrue((newQtyOnHandHQ.compareTo(qtyOnHandHQ.subtract(qtyMove)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((newQtyOnHandStore.compareTo(qtyOnHandStore.add(qtyMove)) == 0 ? 1 : 0) != 0);
        this.rollback();
        qtyOnHandHQ = MStorageOnHand.getQtyOnHandWithASIZero((int)124, (int)103, (String)this.getTrxName());
        qtyOnHandStore = MStorageOnHand.getQtyOnHandWithASIZero((int)124, (int)104, (String)this.getTrxName());
        mh = new MMovement(Env.getCtx(), 0, this.getTrxName());
        mh.setM_Warehouse_ID(103);
        mh.setM_WarehouseTo_ID(104);
        mh.saveEx();
        ml = new MMovementLine(mh);
        ml.setM_Product_ID(124);
        ml.setM_LocatorTo_ID(MWarehouse.get((int)104).getDefaultLocator().get_ID());
        ml.setM_Locator_ID(MWarehouse.get((int)103).getDefaultLocator().get_ID());
        qtyMove = BigDecimal.ONE;
        ml.setQtyEntered(qtyMove);
        ml.setC_UOM_ID(109);
        ml.saveEx();
        BigDecimal movementQty = MUOMConversion.convertProductFrom((Properties)Env.getCtx(), (int)124, (int)109, (BigDecimal)qtyMove);
        Assertions.assertFalse((ml.getQtyEntered().compareTo(ml.getMovementQty()) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((ml.getMovementQty().compareTo(movementQty) == 0 ? 1 : 0) != 0);
        mh.processIt("CO");
        newQtyOnHandHQ = MStorageOnHand.getQtyOnHandWithASIZero((int)124, (int)103, (String)this.getTrxName());
        newQtyOnHandStore = MStorageOnHand.getQtyOnHandWithASIZero((int)124, (int)104, (String)this.getTrxName());
        Assertions.assertFalse((newQtyOnHandHQ.compareTo(qtyOnHandHQ.subtract(qtyMove)) == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((newQtyOnHandStore.compareTo(qtyOnHandStore.add(qtyMove)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((newQtyOnHandHQ.compareTo(qtyOnHandHQ.subtract(movementQty)) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((newQtyOnHandStore.compareTo(qtyOnHandStore.add(movementQty)) == 0 ? 1 : 0) != 0);
        this.rollback();
        mh = new MMovement(Env.getCtx(), 0, this.getTrxName());
        mh.setM_Warehouse_ID(103);
        mh.setM_WarehouseTo_ID(104);
        mh.saveEx();
        ml = new MMovementLine(mh);
        ml.setM_Product_ID(124);
        ml.setM_LocatorTo_ID(MWarehouse.get((int)104).getDefaultLocator().get_ID());
        ml.setM_Locator_ID(MWarehouse.get((int)103).getDefaultLocator().get_ID());
        ml.setMovementQty(qtyMove);
        ml.setC_UOM_ID(109);
        boolean success = ml.save();
        Assertions.assertFalse((boolean)success);
        this.rollback();
    }
}

